
'''
Text File Shuffler
by wrybread@wrybread.com
October 2007

Takes a text file and shuffles it line by line. So for example,
if the input file looks like this:

line1
line2
line3
line4

The output file might like this:

line4
line1
line2
line3

Not much to it.


GUI usage:

Just run shuffle.exe then browse to the input file, and it'll tell you
what the output file is.

Commandline usage:

shuffle.exe [input file] [output file]

For example, if you want to shuffle c:\somefile.txt, you'd type:

shuffle.exe c:\somefile.txt

This would output c:\somefile-shuffled.txt

Or if you want to specify the output file, you'd type:

shuffle.exe c:\somefile.txt c:\shuffled.txt


Python source code include as shuffle.py.

Feel free to email wrybread@wrybread.com with any questions.


'''



program_version = ".8"




import random, os, time, sys

# note: EasyDialogs is imported if nothing is passed from commandline




print ""
print "Text File Shuffler! v" + program_version
print "By wrybread@wrybread.com"
print ""
print "Pass an input text file either from commandline or dialog"
print "and shuffle it up."
print ""



# See if we were passed an input file at commandline line
try:
    commands = sys.argv
    input_file = commands[1]
    print "Taking input file from commandline"

    use_gui = "no" # used to keep track of whether to display a dialog at end

# If nothing passed from commandline, launch a browse window
except IndexError:

    import EasyDialogs # you'll have to install this

    # Launch a file browse dialog
    input_file = EasyDialogs.AskFileForOpen(message="Browse for the text file you'd like to shuffle.", typeList=None, version=None, defaultLocation=None, dialogOptionFlags=None, location=None, windowTitle="File Shuffler!", actionButtonLabel=None, cancelButtonLabel=None, popupExtension=None, multiple=None, defaultfn='')

    use_gui = "yes" # used to keep track of whether to display a dialog at end



# See if we were passed an output file at commandline line
try:
    output_file = commands[2]
    print "Taking output file from commandline too"


# No output file was passed from commandline, so append "-shuffled" to the input file
except IndexError:

    directory = os.path.dirname(input_file) # the directory for our output file

    fname_raw = os.path.basename(input_file)
    fname_raw = os.path.splitext(fname_raw)
    fname = fname_raw[0] # filename minus extension 
    ext = fname_raw[1] # just the extension

    # finally compose our output_file
    output_file = directory + "/" + fname + "-shuffled" + ext



# Clean up our input and output filenames
try:
    input_file = input_file.replace("\\", "/")    
    input_file = os.path.abspath(input_file)

    output_file = output_file.replace("\\", "/")    
    output_file = os.path.abspath(output_file)


except:
    print "NO FILENAME PASSED!"

    # cheesy way to raise an error in the next step, since probably
    # no fname was passed from either commandline or dialog
    input_file = "that file."




# Check if the input file exists
if os.path.exists(input_file):
    print "Input file: " + input_file
    print "Shuffled output file: " + output_file
    print ""
    cont = "yes"

else:
    print "Whoops, I can't find " + input_file
    print "Exiting..."
    cont = "no"



# only continue if the variable cont = "yes"
# (in other words, if the input file exists)
if cont == "yes":

    # read the text file into a list (l)
    t1 = file(input_file)
    l = t1.readlines()
    t1.close()
        
    # shuffle the list (l)
    print "Shuffling " + input_file
    random.shuffle(l)
    random.shuffle(l)
    random.shuffle(l)

    #print l


    # convert the list back to a variable that we can write to a text file
    message = ""
    for line in l:

        if line != "\n": # this eliminates blank lines in our output file
            message = message + line 


    print "Saving " + output_file
    t2 = open(output_file, "w")
    t2.write(message)
    t2.close()

    print "All done."

    if use_gui == "yes":
        EasyDialogs.Message("Shuffled file saved as:\n" + output_file, id=260, ok=None)



